#include <QCoreApplication>

#include "playercontrol.hpp"
#include "consoleout.hpp"
#include "acmeplayer.hpp"
#include "inputreader.hpp"

int main(int argc, char *argv[])
{
  QCoreApplication a(argc, argv);

  ConsoleOut        uiOut;
  AcmeControl       acmeCntrl;
  PlayerControl     cntrl;
  InputReader       inRead;

  QObject::connect(&cntrl, SIGNAL(doPause()), &acmeCntrl, SLOT(doPause()));
  QObject::connect(&cntrl, SIGNAL(doStart()), &acmeCntrl, SLOT(doStart()));
  QObject::connect(&cntrl, SIGNAL(doStop()), &acmeCntrl, SLOT(doStop()));

  QObject::connect(&cntrl, SIGNAL(sayPause()), &uiOut, SLOT(sayPause()));
  QObject::connect(&cntrl, SIGNAL(sayPlay()), &uiOut, SLOT(sayPlay()));
  QObject::connect(&cntrl, SIGNAL(sayStop()), &uiOut, SLOT(sayStop()));

  QObject::connect(&inRead, SIGNAL(playPause()), &cntrl, SLOT(playPause()));
  QObject::connect(&inRead, SIGNAL(stop()), &cntrl, SLOT(stop()));

  QObject::connect(&inRead, SIGNAL(paused()), &cntrl, SLOT(paused()));
  QObject::connect(&inRead, SIGNAL(started()), &cntrl, SLOT(started()));
  QObject::connect(&inRead, SIGNAL(stopped()), &cntrl, SLOT(stopped()));

  inRead.run();

  return a.exec();
}
